require("dotenv").config();
var port = process.env.PORT || 1337;
var express = require("express");
var nodemailer = require('nodemailer');
const { SitemapStream, streamToPromise } = require('sitemap')
const { createGzip } = require('zlib')
const { Readable } = require('stream')

var app = express();
let sitemap

app.use(express.static(__dirname + '/public'));
app.use(express.urlencoded({ extended: true }));
app.use(express.urlencoded({ extended: true }));
app.set("view engine", "ejs");

app.get("/", (request,response)=> {
    response.render("Mazoe.ejs");
});
app.post("/mail", (request, response) => {
    
  var transporter = nodemailer.createTransport({
      pool: true,
      host: process.env.HOST,
      port: 465,
      secure: true,
      auth: {
        user: 'website@mazoebeautyparlour.co.za',
        pass: process.env.PASS
      },
      tls: {
        // do not fail on invalid certs
        rejectUnauthorized: false,
      },
    });
    const source = request.body.MailAddress;
    const to = 'zolekamgxotshwa@gmail.com';
    const subject = request.body.MailSubject;
    const message = request.body.Mailbody;
    console.log(`${source}, ${subject}, ${message}`);
    var mailOptions = {
      from: source,
      to: to,
      subject: 'Website Query: '+subject,
      text: message
    };
    
    transporter.sendMail(mailOptions, function(error, info){
      if (error) {
        console.log(error);
        response.render("failure.ejs")
      } else {
        console.log('Email sent: ' + info.response);
        response.render("success.ejs")
      }
    });
    
})
app.get("/Home", (request,response)=> {
    response.redirect("/")
});
app.get("/Contact", (request,response)=> {
  response.render("contact.ejs");
});
app.get("/Gallery", (request,response)=> {
  response.render("Gallery.ejs");
});
app.get('/sitemap.xml', function(req, res) {
  res.header('Content-Type', 'application/xml');
  res.header('Content-Encoding', 'gzip');
  // if we have a cached entry send it
  if (sitemap) {
    res.send(sitemap)
    return
  }

  try {
    const smStream = new SitemapStream({ hostname: 'https://consumall.online/' })
    const pipeline = smStream.pipe(createGzip())

    // pipe your entries or directly write them.
    smStream.write({ url: 'http://mazoebeautyparlour.co.za/', priority: 0.80 })
    smStream.write({ url: 'http://mazoebeautyparlour.co.za/Contact/', priority: 0.7 })
    smStream.write({ url: 'http://mazoebeautyparlour.co.za/Gallery/', priority: 0.5})

    // cache the response
    streamToPromise(pipeline).then(sm => sitemap = sm)
    // make sure to attach a write stream such as streamToPromise before ending
    smStream.end()
    // stream write the response
    pipeline.pipe(res).on('error', (e) => {throw e})
  } catch (e) {
    console.error(e)
    //server error
    res.status(500).end()
  }
})
app.use((request,response)=>{
    response.render("404.ejs");
});

app.use('/public', express.static('public'))
app.listen(port, () =>{
  console.log('Server listening on port ' + port)
});
